clear;
clc;
warning off;
addpath(genpath('./'));

%% dataset
ds = {'BMNC-I'};
dsPath = './datasets/';


for dsi =1:1:length(ds)
    dataName = ds{dsi}; disp(dataName);
    load(strcat(dsPath,dataName));
    k = length(unique(Y));
    n = length(Y);
    numview = length(X);

    threshold = 0.1;
    lambda = [100];

    for iv = 1:1:numview
        X{iv} = double(X{iv});
        H{iv} = findMP(X{iv},k,threshold);
    end
        
    %%
    allresult = [];
    for id = 1:length(lambda)
        tic;
        [S,iter,obj] = RAM_MVC(X,Y,H,lambda(id),k);
        F = SpectralClustering((S+S')/2, k);
        stream = RandStream.getGlobalStream;
        reset(stream);
        MAXiter = 1000; % Maximum number of iterations for KMeans
        REPlic = 20; % Number of replications for KMeans
        time1 = toc;
        for rep = 1 : 20
            pY = kmeans(F, k, 'maxiter', MAXiter, 'replicates', REPlic, 'emptyaction', 'singleton');
            res(rep, : ) = Clustering8Measure(Y, pY);
        end
        allresult = [allresult;mean(res) std(res) time1];
    end
    [c,d] = max(allresult(:,1));
    maxresult = allresult(d,:);
end


